/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws;

import filenet.vw.api.VWSession;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWQuickSort;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import filenet.vw.toolkit.utils.ws.VWUDDIBusinessServiceTableModel;
import filenet.vw.toolkit.utils.ws.VWUDDIProcessMonitorDialog;
import filenet.vw.toolkit.utils.ws.VWUDDIRegistryComboBoxRenderer;
import filenet.vw.toolkit.utils.ws.VWUDDIRegistryManager;
import filenet.vw.toolkit.utils.ws.VWWSWorkflow;
import filenet.vw.toolkit.utils.ws.base.VWUDDIRegistryItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public final class VWUDDIWorkflowPublishPanel
extends JPanel
implements ActionListener,
TableModelListener,
IVWToolbarBorderActionListener,
ListSelectionListener {
    private Frame m_parentFrame = null;
    private VWSession m_session = null;
    private VWUDDIRegistryManager m_uddiRegistryManager = null;
    private VWWSWorkflow[] m_wsWorkflows = null;
    private JSplitPane m_mainPanel = null;
    private JPanel m_queryPanel = null;
    private JPanel m_selectedServicesPanel = null;
    private JTextField m_workflowQueryNameUI = null;
    private JButton m_serchButton = null;
    private WorkflowQuery m_workflowQueryObject = null;
    private VWTable m_queryServicesTable = null;
    private VWUDDIBusinessServiceTableModel m_queryServicesTableModel = null;
    private VWToolbarBorder m_queryServicesToolbarBorder = null;
    private ListSelectionModel m_queryServicesTableListSelectionModel = null;
    private VWTable m_selectedServicesTable = null;
    private VWUDDIBusinessServiceTableModel m_selectedServicesTableModel = null;
    private VWToolbarBorder m_selectedServicesToolbarBorder = null;
    private ListSelectionModel m_selectedServicesListSelectionModel = null;
    private boolean m_bFirstTime = false;
    private JComboBox m_uddiRegistryCombo = null;
    private JButton m_publishButton = null;

    public static String _get_FILE_DATE() {
        return "$Date:   13 Feb 2009 17:56:28  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   dsiegfried  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.33  $";
    }

    public VWUDDIWorkflowPublishPanel(Frame parent, VWSession session, VWUDDIRegistryManager uddiRegistryManager) {
        super(new BorderLayout(5, 5));
        this.m_parentFrame = parent;
        this.m_session = session;
        this.m_uddiRegistryManager = uddiRegistryManager;
        this.m_uddiRegistryCombo = new JComboBox();
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.m_uddiRegistryCombo.getModel();
        if (model != null) {
            model.removeAllElements();
            model.addElement(VWResource.s_ellipse.toString(VWResource.s_validatingServerCertificate));
            this.m_uddiRegistryCombo.setSelectedIndex(0);
        }
        this.m_workflowQueryObject = new WorkflowQuery();
        this.createQueryPanel();
        this.createSelectedServicesPanel();
        this.m_mainPanel = new JSplitPane(0, this.m_queryPanel, this.m_selectedServicesPanel);
        this.m_mainPanel.setToolTipText(VWResource.s_slideToAdjustView);
        this.m_mainPanel.setOneTouchExpandable(true);
        this.m_mainPanel.setDividerSize(6);
        this.m_mainPanel.setDividerLocation(200);
        this.setLayout(new BorderLayout(3, 3));
        this.add((Component)this.m_mainPanel, "Center");
        JPanel bottomPanel = this.createBottomPanel();
        this.add((Component)bottomPanel, "Last");
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.m_bFirstTime) {
            this.m_bFirstTime = false;
            if (this.m_mainPanel != null) {
                this.m_mainPanel.setDividerLocation(200);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_workflowQueryNameUI) {
            this.executeWorkflowQuery();
        } else if (source == this.m_serchButton) {
            this.executeWorkflowQuery();
        } else if (source == this.m_publishButton) {
            this.publish();
        } else if (source == this.m_uddiRegistryCombo) {
            this.onRegistrySelection();
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            switch (event.getID()) {
                case 0x10000000: {
                    int[] rows = this.m_selectedServicesTable.getSelectedRows();
                    for (int nIndex = rows.length - 1; nIndex >= 0; --nIndex) {
                        this.m_selectedServicesTableModel.removeRow(rows[nIndex]);
                    }
                    break;
                }
                case 0x1000000: {
                    int nIndex;
                    int[] rows = this.m_queryServicesTable.getSelectedRows();
                    Vector<VWWSWorkflow> WFVector = new Vector<VWWSWorkflow>();
                    for (nIndex = 0; nIndex < rows.length; ++nIndex) {
                        VWWSWorkflow selectedWF = this.m_queryServicesTableModel.getWorkflowAt(rows[nIndex]);
                        int idx = this.m_selectedServicesTableModel.find(selectedWF);
                        if (idx >= 0) {
                            this.m_selectedServicesTableModel.removeRow(idx);
                        }
                        WFVector.add(selectedWF);
                    }
                    if (WFVector.size() > 0) {
                        this.m_selectedServicesTableModel.addData(WFVector);
                    }
                    for (nIndex = rows.length - 1; nIndex >= 0; --nIndex) {
                        this.m_queryServicesTableModel.removeRow(rows[nIndex]);
                    }
                    break;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        Object source = event.getSource();
        if (source == this.m_selectedServicesListSelectionModel) {
            if (!event.getValueIsAdjusting()) {
                JPanel clientPanel = this.m_selectedServicesToolbarBorder.getClientPanel();
                int nRowIndex = this.m_selectedServicesTable.getSelectedRow();
                int nRowCount = this.m_selectedServicesTable.getRowCount();
                if (this.m_selectedServicesTableModel != null && nRowIndex != -1) {
                    this.m_selectedServicesToolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(clientPanel, 1, 0x10000000));
                } else {
                    this.m_selectedServicesToolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(clientPanel, 2, 0x10000000));
                }
            }
        } else if (source == this.m_queryServicesTableListSelectionModel && !event.getValueIsAdjusting()) {
            JPanel clientPanel = this.m_queryServicesToolbarBorder.getClientPanel();
            int nRowIndex = this.m_queryServicesTable.getSelectedRow();
            int nRowCount = this.m_queryServicesTable.getRowCount();
            if (this.m_queryServicesTableModel != null && nRowIndex != -1) {
                this.m_queryServicesToolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(clientPanel, 1, 0x1000000));
            } else {
                this.m_queryServicesToolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(clientPanel, 2, 0x1000000));
            }
        }
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case 1: {
                if (this.m_selectedServicesTable.getRowCount() <= 0) break;
                int lastRow = event.getLastRow() - 1;
                int firstRow = event.getFirstRow();
                if (lastRow < 0) {
                    lastRow = 0;
                }
                if (lastRow == this.m_selectedServicesTable.getSelectedRow()) {
                    this.m_selectedServicesTable.clearSelection();
                }
                this.m_selectedServicesTable.setRowSelectionInterval(firstRow, lastRow);
                this.m_selectedServicesTable.ensureRowIsVisible(lastRow);
            }
        }
    }

    protected void initData(VWUDDIRegistryManager uddiRegistryManager) {
        VWUDDIRegistryItem[] uddiRegistryItemArray = null;
        if (uddiRegistryManager != null) {
            uddiRegistryItemArray = uddiRegistryManager.getUDDIRegistryItemList();
        }
        if (uddiRegistryItemArray != null) {
            this.initUDDIReigstryComboBox(uddiRegistryItemArray);
        } else {
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.m_uddiRegistryCombo.getModel();
            if (model != null) {
                model.removeAllElements();
                this.m_uddiRegistryCombo.setSelectedIndex(-1);
            }
        }
    }

    private void createQueryPanel() {
        this.m_queryPanel = new JPanel();
        this.m_queryPanel.setLayout(new BorderLayout(4, 4));
        VWToolbarBorder searchToolbarBorder = new VWToolbarBorder(VWResource.s_searchWebServicesWorkflows, 0);
        JPanel panel = searchToolbarBorder.getClientPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
        panel.setLayout(new GridBagLayout());
        VWAccessibilityHelper.setAccessibility(searchToolbarBorder, this, VWResource.s_searchWebServicesWorkflows, VWResource.s_searchWebServicesWorkflows);
        this.m_workflowQueryNameUI = new JTextField();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 23;
        c.fill = 1;
        panel.add((Component)this.m_workflowQueryNameUI, c);
        VWAccessibilityHelper.setAccessibility(this.m_workflowQueryNameUI, this, VWResource.s_searchWebServicesWorkflows, VWResource.s_searchWebServicesWorkflows);
        this.m_serchButton = new JButton(VWImageLoader.createImageIcon("search.gif"));
        this.m_serchButton.setName("m_serchButton");
        this.m_serchButton.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_serchButton, this, VWResource.s_search, VWResource.s_search);
        c.gridx = 1;
        c.weightx = 0.0;
        panel.add((Component)this.m_serchButton, c);
        this.m_queryServicesToolbarBorder = new VWToolbarBorder(VWResource.s_webServicesWorkflowsSearchResult, 0x1000000);
        this.m_queryServicesToolbarBorder.addToolbarBorderActionNotifier(this);
        VWAccessibilityHelper.setAccessibility(this.m_queryServicesToolbarBorder, this, VWResource.s_webServicesWorkflowsSearchResult, VWResource.s_webServicesWorkflowsSearchResult);
        panel = this.m_queryServicesToolbarBorder.getClientPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
        panel.setLayout(new BorderLayout(4, 4));
        this.initWebServicesWorkflowTable();
        panel.add((Component)new JScrollPane(this.m_queryServicesTable), "Center");
        VWAccessibilityHelper.setAccessibility(this.m_queryServicesTable, this, VWResource.s_webServicesWorkflowsSearchResultTable, VWResource.s_webServicesWorkflowsSearchResultTable);
        this.m_queryPanel.add((Component)searchToolbarBorder, "First");
        this.m_queryPanel.add((Component)this.m_queryServicesToolbarBorder, "Center");
    }

    private void createSelectedServicesPanel() {
        this.m_selectedServicesPanel = new JPanel();
        this.m_selectedServicesPanel.setLayout(new BorderLayout(4, 4));
        this.m_selectedServicesToolbarBorder = new VWToolbarBorder(VWResource.s_webServicesWorkflowsToPublish, 0x10000000);
        this.m_selectedServicesToolbarBorder.addToolbarBorderActionNotifier(this);
        VWAccessibilityHelper.setAccessibility(this.m_selectedServicesToolbarBorder, this, VWResource.s_webServicesWorkflowsToPublish, VWResource.s_webServicesWorkflowsToPublish);
        JPanel panel = this.m_selectedServicesToolbarBorder.getClientPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
        panel.setLayout(new BorderLayout(4, 4));
        this.initSelectedServicesTable();
        panel.add((Component)new JScrollPane(this.m_selectedServicesTable), "Center");
        this.m_selectedServicesPanel.add((Component)this.m_selectedServicesToolbarBorder, "Center");
        VWAccessibilityHelper.setAccessibility(this.m_selectedServicesTable, this, VWResource.s_webServicesWorkflowsToPublish, VWResource.s_webServicesWorkflowsToPublish);
    }

    private JPanel createBottomPanel() {
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout(4, 4));
        VWToolbarBorder uddiRegistryToolbarBorder = new VWToolbarBorder(VWResource.s_selectUDDIRegistry, 0);
        JPanel panel = uddiRegistryToolbarBorder.getClientPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        panel.add((Component)this.m_uddiRegistryCombo, c);
        VWAccessibilityHelper.setAccessibility(this.m_uddiRegistryCombo, this, VWResource.s_selectUDDIRegistry, VWResource.s_selectUDDIRegistry);
        this.m_publishButton = new JButton(VWResource.s_publish);
        this.m_publishButton.setEnabled(false);
        this.m_publishButton.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_publishButton, this, VWResource.s_publish, VWResource.s_publish);
        c.weightx = 0.0;
        c.weighty = 0.0;
        ++c.gridx;
        c.fill = 0;
        c.anchor = 22;
        panel.add((Component)this.m_publishButton, c);
        bottomPanel.add((Component)uddiRegistryToolbarBorder, "Center");
        VWAccessibilityHelper.setAccessibility(uddiRegistryToolbarBorder, this, VWResource.s_selectUDDIRegistry, VWResource.s_selectUDDIRegistry);
        return bottomPanel;
    }

    public void initSelectedServicesTable() {
        this.m_selectedServicesTableModel = new VWUDDIBusinessServiceTableModel();
        this.m_selectedServicesTable = new VWTable(this.m_selectedServicesTableModel);
        this.m_selectedServicesTableModel.addTableModelListener(this);
        this.m_selectedServicesTable.setRowSelectionAllowed(true);
        this.m_selectedServicesListSelectionModel = this.m_selectedServicesTable.getSelectionModel();
        this.m_selectedServicesListSelectionModel.addListSelectionListener(this);
        this.m_selectedServicesTable.getSelectionModel().addListSelectionListener(this);
        this.m_selectedServicesTable.setEnabled(true);
        if (this.m_selectedServicesTable.getRowCount() > 0) {
            this.m_selectedServicesTable.setRowSelectionInterval(0, 0);
        } else {
            this.m_selectedServicesToolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_selectedServicesToolbarBorder.getClientPanel(), 2, 0x10000000));
        }
    }

    public void initWebServicesWorkflowTable() {
        this.m_queryServicesTableModel = new VWUDDIBusinessServiceTableModel();
        this.m_queryServicesTable = new VWTable(this.m_queryServicesTableModel);
        this.m_queryServicesTableModel.addTableModelListener(this.m_queryServicesTable);
        this.m_queryServicesTable.setRowSelectionAllowed(true);
        this.m_queryServicesTableListSelectionModel = this.m_queryServicesTable.getSelectionModel();
        this.m_queryServicesTable.getSelectionModel().addListSelectionListener(this);
        this.m_queryServicesTable.setEnabled(true);
        if (this.m_queryServicesTable.getRowCount() > 0) {
            this.m_queryServicesTable.setRowSelectionInterval(0, 0);
        } else {
            this.m_queryServicesToolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_queryServicesToolbarBorder.getClientPanel(), 2, 0x1000000));
        }
    }

    private void initUDDIReigstryComboBox(VWUDDIRegistryItem[] uddiRegistryItemArray) {
        if (uddiRegistryItemArray != null) {
            this.m_uddiRegistryCombo.removeAllItems();
            Object obj = null;
            String registryName = null;
            for (int i = 0; i < uddiRegistryItemArray.length; ++i) {
                if (uddiRegistryItemArray[i] == null) continue;
                registryName = uddiRegistryItemArray[i].getName();
                String name = null;
                boolean bInserted = false;
                int listSz = this.m_uddiRegistryCombo.getItemCount();
                for (int j = 0; j < listSz; ++j) {
                    obj = this.m_uddiRegistryCombo.getItemAt(j);
                    if (obj == null || !(obj instanceof VWUDDIRegistryItem) || VWStringUtils.compareIgnoreCase(registryName, name = ((VWUDDIRegistryItem)obj).getName()) >= 0) continue;
                    this.m_uddiRegistryCombo.insertItemAt(uddiRegistryItemArray[i], j);
                    bInserted = true;
                    break;
                }
                if (bInserted) continue;
                this.m_uddiRegistryCombo.addItem(uddiRegistryItemArray[i]);
            }
        }
        this.m_uddiRegistryCombo.setSelectedIndex(-1);
        this.m_uddiRegistryCombo.setRenderer(new VWUDDIRegistryComboBoxRenderer());
        this.m_uddiRegistryCombo.addActionListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeWorkflowQuery() {
        if (this.m_workflowQueryObject == null) return;
        Cursor currentCursor = null;
        try {
            block9: {
                try {
                    currentCursor = this.getCursor();
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    if (this.m_workflowQueryNameUI == null) break block9;
                    this.m_wsWorkflows = this.m_workflowQueryObject.findWorkflowByName(this.m_workflowQueryNameUI.getText());
                    if (this.m_wsWorkflows != null && this.m_wsWorkflows.length > 0) {
                        VWQuickSort sort = new VWQuickSort(this.m_wsWorkflows, 0);
                        sort.sort(0, this.m_wsWorkflows.length - 1);
                    }
                    if (this.m_queryServicesTableModel == null) {
                        this.m_queryServicesTableModel = new VWUDDIBusinessServiceTableModel(this.m_wsWorkflows);
                        if (this.m_queryServicesTable == null) {
                            this.m_queryServicesTable = new VWTable(this.m_queryServicesTableModel);
                        } else {
                            this.m_queryServicesTable.setModel(this.m_queryServicesTableModel);
                        }
                    } else {
                        this.m_queryServicesTableModel.setData(this.m_wsWorkflows);
                    }
                    this.m_queryServicesTableModel.fireTableDataChanged();
                }
                catch (Exception ex) {
                    this.showMessage(VWResource.s_failedToQueryForTModels, VWResource.s_error, 1, ex);
                    VWDebug.logException(ex, "VWUDDIWorkflowPublishPanel::executeWorkflowQuery");
                    Object var4_5 = null;
                    if (currentCursor == null) return;
                    this.setCursor(currentCursor);
                    return;
                }
            }
            Object var4_4 = null;
            if (currentCursor == null) return;
            this.setCursor(currentCursor);
            return;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (currentCursor == null) throw throwable;
            this.setCursor(currentCursor);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void publish() {
        Cursor currentCursor;
        block19: {
            block18: {
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                currentCursor = null;
                                try {
                                    try {
                                        VWWSWorkflow[] selectedWorkflows = null;
                                        VWUDDIRegistryItem selectedUDDIRegistry = null;
                                        if (this.m_selectedServicesTableModel != null) {
                                            selectedWorkflows = this.m_selectedServicesTableModel.getData();
                                        }
                                        if (this.m_uddiRegistryCombo != null) {
                                            Object obj = this.m_uddiRegistryCombo.getSelectedItem();
                                            selectedUDDIRegistry = obj instanceof VWUDDIRegistryItem ? (VWUDDIRegistryItem)obj : null;
                                        }
                                        if (this.m_selectedServicesTableModel.getRowCount() == 0) {
                                            this.showMessage(VWResource.s_pleaseSearchAndSelectWorkflowsToPublish, VWResource.s_publishing, 2);
                                            Object var7_6 = null;
                                            if (currentCursor == null) return;
                                            break block14;
                                        }
                                        if (selectedWorkflows == null || selectedWorkflows.length == 0) {
                                            this.showMessage(VWResource.s_pleaseSelectOneOrMoreWorkflowsToPublish, VWResource.s_publishing, 2);
                                            break block15;
                                        }
                                        if (selectedUDDIRegistry == null) {
                                            this.showMessage(VWResource.s_pleaseSelectAUddiRegistryForPublishing, VWResource.s_publishing, 2);
                                            break block16;
                                        }
                                        if (this.m_uddiRegistryManager.authenticate(this.m_parentFrame, selectedUDDIRegistry) != VWUDDIRegistryManager.UDDI_AUTHENTICATE_SUCCESS) {
                                            break block17;
                                        }
                                        String businessKey = selectedUDDIRegistry.getVWUDDIRegistry().getBusinessKey();
                                        if (businessKey == null || businessKey.length() <= 0) {
                                            currentCursor = this.getCursor();
                                            this.setCursor(Cursor.getPredefinedCursor(3));
                                            if (this.m_uddiRegistryManager.publishBusiness(this.m_parentFrame, selectedUDDIRegistry) == null) {
                                                break block18;
                                            }
                                            this.m_uddiRegistryCombo.updateUI();
                                            if (currentCursor != null) {
                                                this.setCursor(currentCursor);
                                            }
                                        }
                                        VWUDDIProcessMonitorDialog publishMonitor = new VWUDDIProcessMonitorDialog(this.m_parentFrame, this.m_uddiRegistryManager, selectedUDDIRegistry, selectedWorkflows, 2, VWResource.s_publishWorkflow);
                                        publishMonitor.setVisible(true);
                                        publishMonitor.releaseResources();
                                        break block19;
                                    }
                                    catch (Exception ex) {
                                        VWDebug.logException(ex);
                                        Object var7_12 = null;
                                        if (currentCursor == null) return;
                                        this.setCursor(currentCursor);
                                        return;
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var7_13 = null;
                                    if (currentCursor == null) throw throwable;
                                    this.setCursor(currentCursor);
                                    throw throwable;
                                }
                            }
                            this.setCursor(currentCursor);
                            return;
                        }
                        Object var7_7 = null;
                        if (currentCursor == null) return;
                        this.setCursor(currentCursor);
                        return;
                    }
                    Object var7_8 = null;
                    if (currentCursor == null) return;
                    this.setCursor(currentCursor);
                    return;
                }
                Object var7_9 = null;
                if (currentCursor == null) return;
                this.setCursor(currentCursor);
                return;
            }
            Object var7_10 = null;
            if (currentCursor == null) return;
            this.setCursor(currentCursor);
            return;
        }
        Object var7_11 = null;
        if (currentCursor == null) return;
        this.setCursor(currentCursor);
    }

    private void onRegistrySelection() {
        Object item = this.m_uddiRegistryCombo.getSelectedItem();
        if (item instanceof VWUDDIRegistryItem) {
            VWUDDIRegistryItem registryItem = (VWUDDIRegistryItem)item;
            if (registryItem.isConnected()) {
                this.m_publishButton.setEnabled(true);
            } else {
                this.m_publishButton.setEnabled(false);
            }
        } else {
            this.m_publishButton.setEnabled(false);
        }
    }

    private String showMessage(String msg, String title, int msgType) {
        return this.showMessage(msg, title, msgType, null);
    }

    private String showMessage(String msg, String title, int msgType, Exception ex) {
        if (ex != null) {
            msg = msg == null ? new String(ex.toString()) : msg + "\n" + ex.toString();
        }
        VWMessageDialog.showOptionDialog(this.m_parentFrame, msg, title, msgType);
        return msg;
    }

    class WorkflowQuery {
        public String toString() {
            return VWResource.s_webServicesWorkflows;
        }

        public VWWSWorkflow[] findWorkflowByName(String name) throws Exception {
            Vector<VWWSWorkflow> wsWorkflows = new Vector<VWWSWorkflow>();
            if (name != null && VWUDDIWorkflowPublishPanel.this.m_session != null) {
                int queryNameLen = -1;
                if (name != null) {
                    queryNameLen = name.length();
                }
                String[] wcNames = VWUDDIWorkflowPublishPanel.this.m_session.fetchWorkClassNames(true);
                VWWorkflowSignature sig = null;
                if (wcNames != null && wcNames.length > 0) {
                    for (int i = 0; i < wcNames.length; ++i) {
                        String wcName = wcNames[i];
                        if (wcName == null) continue;
                        if (queryNameLen > 0 && wcName.length() >= queryNameLen) {
                            String s = null;
                            s = wcName.substring(0, queryNameLen);
                            if (VWStringUtils.compareIgnoreCase(s, name) != 0) continue;
                        }
                        if ((sig = VWUDDIWorkflowPublishPanel.this.m_session.fetchWorkflowSignature(wcNames[i])) == null || sig.getPartnerlinkNames() == null || sig.getPartnerlinkNames().length <= 0 || !sig.getHasMyPortType()) continue;
                        wsWorkflows.add(new VWWSWorkflow(sig));
                    }
                }
            }
            if (wsWorkflows != null && wsWorkflows.size() > 0) {
                VWWSWorkflow[] array = new VWWSWorkflow[wsWorkflows.size()];
                wsWorkflows.toArray(array);
                return array;
            }
            return null;
        }
    }
}

